﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    public enum Filter {
        Razem,
        [Caption("Z limitem")]
        ZLimitem, 
        BezLimitu
    }
    
    public class Params : ContextBase {
        
        public Params(Context context)
            : base(context) {

            definicja = KalendModule.GetInstance(this).DefinicjeLimitow.UrlopWypoczynkowy;
        }

        DefinicjaLimitu definicja;
        [Priority(10)]
        [Required]
        [Caption("Limit nieobecności")]
        public DefinicjaLimitu Definicja {
            get { return definicja; }
            set {
                definicja = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicja() {
            return DefinicjeLimitow.Definicje(this);
        }

        Filter filter = Filter.ZLimitem;
        [Priority(20)]
        [Caption("Pracownicy")]
        public Filter Filter {
            get { return filter; }
            set {
                filter = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }

    Date data;
    [Context(typeof(ActualDate), "Actual")]
    public Date Data {
        set { data = value; }
    }

    bool naGodziny;
    bool kumulowany;
    protected void dc_ContextLoad(object sender, EventArgs e) {
        ReportHeader["LIMIT"] = pars.Definicja.Nazwa;
        naGodziny = (pars.Definicja.Naliczanie == NaliczanieLimitu.WypoczynkowyNaGodziny ||
                     pars.Definicja.Naliczanie == NaliczanieLimitu.OpiekaNaGodziny);
        kumulowany = pars.Definicja.Kumulowany;
        
        dniPrzenies.Visible = !naGodziny && kumulowany;
        dniPrzeniesWyk.Visible = !naGodziny && kumulowany;
        dniLimit.Visible = !naGodziny;
        dniLimitWyk.Visible = !naGodziny;
        dniPozostało.Visible = !naGodziny;

        godzPrzenies.Visible = naGodziny && kumulowany;
        godzPrzeniesWyk.Visible = naGodziny && kumulowany;
        godzLimit.Visible = naGodziny;
        godzLimitWyk.Visible = naGodziny;
        godzPozostałoDni.Visible = naGodziny && (pars.Definicja.Guid!=new Guid("00000000-0006-0004-0005-000000000000")); //"Urlop opiekuńczy (art 188 kp, godz.)"
        godzPozostałoGodz.Visible = naGodziny;
    }

    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        Pracownik idx = (Pracownik)args.Row;
        LimitNieobecnosci limit = (LimitNieobecnosci)KalendModule.GetInstance(idx).LimNieobecnosci.WgPracownik[idx, pars.Definicja][data];
        bool visible;
        switch (pars.Filter) {
            case Filter.BezLimitu:
                args.VisibleRow &= limit == null;
                break;
            case Filter.ZLimitem:
                args.VisibleRow &= limit != null;
                break;
        }

        if (args.VisibleRow && limit != null)
            if (naGodziny) {
                if (kumulowany) {
                    Time pw = Time.Min(limit.WykorzystaneGodz, limit.PrzeniesienieGodz);
                    if (pw != Time.Zero)
                        foreach (OkresNieobecności on in idx.Czasy.Nieobecnosci(FromTo.Year(data), true))
                            if (on.Urlop.Przyczyna == PrzyczynaUrlopu.NaŻądanie)
                                pw -= on.Norma().Czas;
                    godzPrzenies.EditValue = limit.PrzeniesienieGodz;
                    godzPrzeniesWyk.EditValue = pw;
                    godzLimit.EditValue = limit.LimitGodz - limit.WykorzystanyPoprzGodz + limit.ZmianaGodz;
                    godzLimitWyk.EditValue = limit.WykorzystaneGodz - pw;
                }
                else {
                    godzLimit.EditValue = limit.RazemGodz;
                    godzLimitWyk.EditValue = limit.WykorzystaneGodz;
                }
                godzPozostałoDni.EditValue = limit.PozostaloDni;
                godzPozostałoGodz.EditValue = limit.PozostaloGodz;
            }
            else {
                if (kumulowany) {
                    int pw = System.Math.Min(limit.Wykorzystane, limit.Przeniesienie);
                    if (pw != 0)
                        foreach (OkresNieobecności on in idx.Czasy.Nieobecnosci(FromTo.Year(data), true))
                            if (on.Urlop.Przyczyna == PrzyczynaUrlopu.NaŻądanie)
                                pw -= on.Norma().Dni;
                    dniPrzenies.EditValue = limit.Przeniesienie;
                    dniPrzeniesWyk.EditValue = pw;
                    dniLimit.EditValue = limit.LimitDni + limit.Zmiana;
                    dniLimitWyk.EditValue = limit.Wykorzystane - pw;
                }
                else {
                    dniLimit.EditValue = limit.Razem;
                    dniLimitWyk.EditValue = limit.Wykorzystane;
                }
                dniPozostało.EditValue = limit.Pozostalo;
            }
    }

    static void Msg(object value) {
    }
    
</script>

<HTML>
	<HEAD>
		<TITLE>Limity nieobecnosci</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" title="Limity nieobecnosci|</strong>Limit: <strong>%LIMIT%|</strong>Wydział: <strong>{0}|</strong>Pośrednio: <strong>{1}|</strong>Aktualny: <strong>{3}" DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio" DataMember2="KadryPracownicyViewInfo+PrParams.Okres" DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" OnBeforeRow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Pracownik.NazwiskoImię" Caption="Nazwisko i imię pracownika" Width="40"></ea:GridColumn>
                    <ea:GridColumn ID="dniPrzenies" runat="server" Caption="Z przeniesienia~Limit" Align="Center" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="dniPrzeniesWyk" runat="server" Caption="Z przeniesienia~Wykorzystane" Align="Center" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="dniLimit" runat="server" Align="Center" Caption="Bieżący~Limit" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="dniLimitWyk" runat="server" Caption="Bieżący~Wykorzystany" Align="Center" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="dniPozostało" runat="server" Align="Center" Caption="Pozostało dni" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="godzPrzenies" runat="server" Align="Center" Caption="Z przeniesienia~Limit" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="godzPrzeniesWyk" runat="server" Align="Center" Caption="Z przeniesienia~Wykorzystany" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="godzLimit" runat="server" Caption="Bieżący~Limit" Align="Center" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="godzLimitWyk" runat="server" Align="Center" Caption="Bieżący~Wykorzystany" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="godzPozostałoDni" runat="server" Caption="Pozostało~dni wg etatu" Align="Center" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="godzPozostałoGodz" runat="server" Caption="Pozostało~godz." Align="Center" HideZero="True">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

